#include "bits/stdc++.h"
#include "ext/pb_ds/assoc_container.hpp"
#include "ext/pb_ds/tree_policy.hpp"

using namespace std;
using namespace __gnu_pbds;

#define int long long
#define ld long double

using indexed_set = tree<int, null_type, less<>, rb_tree_tag, tree_order_statistics_node_update>;

void solve();

vector<int> sz, p;

int get(int u) {
    if (p[u] == u) return u;
    return p[u] = get(p[u]);
}

void unite(int u, int v) {
    u = get(u);
    v = get(v);
    if (u == v) return;
    if (sz[u] < sz[v]) swap(u, v);
    p[v] = u;
    sz[u] += sz[v];
}

struct point {
    ld x, y;

    point() {
        x = y = 0;
    }

    point(ld _x, ld _y) {
        x = _x;
        y = _y;
    }
};

point operator+(point a, point b) {
    return point(a.x + b.x, a.y + b.y);
}

point operator-(point a, point b) {
    return point(a.x - b.x, a.y - b.y);
}

long double operator%(point a, point b) {
    return a.x * b.y - a.y * b.x;
}

long double operator*(point a, point b) {
    return a.x * b.x + a.y * b.y;
}

bool operator<(point a, point b) {
    if (a.x != b.x) return a.x < b.x;
    return a.y < b.y;
}

istream &operator>>(istream &in, point &a) {
    in >> a.x >> a.y;
    return in;
}

ostream &operator<<(ostream &out, point &a) {
    out << a.x << " " << a.y;
    return out;
}

bool comp(pair<point, int> a, pair<point, int> b) {
    return a.first < b.first;
}

struct line {
    long double a, b, c;

    line() {
        a = 1;
        b = c = 0;
    }

    line(point p1, point p2) {
        ld dy = p2.y - p1.y;
        ld dx = p1.x - p2.x;
        if (dx == 0) {
            a = 1;
            b = 0;
            c = -p1.x;
        } else if (dy == 0) {
            a = 0;
            b = 1;
            c = -p1.y;
        } else {
            a = dy;
            b = dx;
            c = -p1.x * dy - p1.y * dx;
        }
    }
};

bool is_intersect_lines(line l1, line l2) {
    return l1.a * l2.b != l2.a * l1.b || l1.c * l2.a != l1.a * l2.c || l1.b * l2.c != l2.b * l1.c;
}

void sf() {
    cin.tie(nullptr);
    cout.tie(nullptr);
    ios_base::sync_with_stdio(false);
}

point intersect_lines(line a, line b) {
    long double a1 = a.a, b1 = a.b, c1 = a.c, a2 = b.a, b2 = b.b, c2 = b.c;
    point pt( (b2 * c1 - c2 * b1) / (a2 * b1 - b2 * a1), (c2 * a1 - a2 * c1) / (-b2 * a1 + a2 * b1));
    return pt;
}

bool on_segm(point pt, pair<point, point> s) {
    point ab = s.second - s.first;
    point ap = pt - s.first;
    point ba = s.first - s.second;
    point bp = pt - s.second;
    return (ab * ap >= 0 && ba * bp >= 0);
}

bool is_intersect(pair<point, point> s1, pair<point, point> s2) {
    line l1(s1.first, s1.second), l2(s2.first, s2.second);
    if (!is_intersect_lines(l1, l2)) return false;
    point pnt = intersect_lines(l1, l2);
//    cout << pnt << endl;
    if (on_segm(pnt, s1) && on_segm(pnt, s2)) return true;
    return false;
}

point intersect(pair<point, point> s1, pair<point, point> s2) {
    line l1(s1.first, s1.second), l2(s2.first, s2.second);
    point pnt = intersect_lines(l1, l2);
    return pnt;
}

signed main() {
    sf();
//    point a, b, c, d;
//    cin >> a >> b >> c >> d;
//    cout << is_intersect({a, b}, {c, d});
    int t = 0;
    cin >> t;
    while (t--) {
        solve();
        cout << '\n';
    }
}

void solve() {
    int n;
    cin >> n;
    p.assign(n, 0);
    sz.assign(n, 1);
    for (int i = 0; i < n; i++) p[i] = i;
    vector<pair<point, point>> segm;
    int cnt = 0;
    for (int i = 0; i < n; i++) {
        point p1, p2;
        cin >> p1 >> p2;
        pair<point, point> newSegm = make_pair(p1, p2);
        vector<pair<point, int>> indx;
        for (int j = 0; j < i; j++) {
            if (is_intersect(segm[j], newSegm)) {
//                cout << j << endl;
                indx.emplace_back(make_pair(intersect(segm[j], newSegm), j));
            }
        }
        sort(indx.begin(), indx.end(), comp);
        for (int j = 1; j < indx.size(); j++) {
            if (get(indx[j - 1].second) == get(indx[j].second)) cnt++;
        }
        for (int j = 0; j < i; j++) {
            if (is_intersect(segm[j], newSegm)) unite(i, j);
        }
        segm.push_back(newSegm);
//        cout << endl;
//        cout << cnt << endl;
    }
    cout << cnt + 1;
}
